/**********************************************************************************************************************
 Purpose:
 Test the performance of the 4 known good methods for combining DATE and TIME columns into a DATETIME2.

 Each of the 4 methods run a section of code that will absolutely clean proc and buffer cache.  Then the next section
 of code for each test is executed 3 times each to check for first run performance and to make sure that the test
 machine didn't have some anomolous code that might be delaying the duration.

 Each test can be executed separately, if desired.

 This script takes about 70 seconds to execute on my laptop.  YMMV.
-----------------------------------------------------------------------------------------------------------------------
 Dependencies:
 You must first execute the following script included in the ZIP file attached to this article. It creates everything
 need to run the tests below including but not limited to the DateTimeTest datbase and th 10 million row test table.

 0100 - Create the DateTime Test Table - All supporting objects - 10 million row test table.sql
-----------------------------------------------------------------------------------------------------------------------
 Revision History:
 Rev 00 - 11 Jun 2023 - Jeff Moden
                      - Initial creation and unit test.
**********************************************************************************************************************/
GO
--===== Run Starting ==================================================================================================
    SET NOCOUNT ON;
 SELECT [Notice!!!] = 'Check the "Messages" tab to view progress';

--===== Environmental Presets
     -- These are all here just to make it easy to change testing environments and confirm how a test was conducted.
     -- Note that I run my tests using SQL Profiler and I had all the RAISERROR and SET STATISTICS lines commented out.
     -- They're not commented out below.  The CPU and Durations will be displayed in the "Messages" result window so
     -- that you don't need to run SQL Profiler or Extended Events.
  ALTER DATABASE DateTimeTest SET TARGET_RECOVERY_TIME = 1 MINUTES WITH NO_WAIT; --The default. Here so I can change it.
--ALTER DATABASE DateTimeTest SET COMPATIBILITY_LEVEL = 160;    --Just here for additional testing.
  ALTER DATABASE DateTimeTest SET RECOVERY SIMPLE WITH NO_WAIT; --Just here for additional testing.
    USE DateTimeTest;
  ALTER DATABASE SCOPED CONFIGURATION SET LEGACY_CARDINALITY_ESTIMATION = OFF; --Just here for additional testing.
  ALTER DATABASE SCOPED CONFIGURATION SET MAXDOP = 4; --This is the "sweetspot" on my 32 CPU PRODCTION box at work.
        CHECKPOINT;
GO
--=====================================================================================================================
--===== Clear proc and buffer cache only on the DateTimeTest database without affecting any others.
  PRINT REPLICATE('=',119);
    USE master;
  ALTER DATABASE DateTimeTest SET OFFLINE WITH ROLLBACK IMMEDIATE;
  ALTER DATABASE DateTimeTest SET ONLINE;
    USE DateTimeTest;
        CHECKPOINT;
GO
--===== Method 1 Performance Test =====================================================================================
        RAISERROR('********** Method 1 **********',0,0) WITH NOWAIT;
DECLARE @BitBucket DATETIME2; --Takes display time out of the picture.
    SET STATISTICS TIME ON;
 SELECT @BitBucket = DATEADD(dd,DATEDIFF(dd,'1900',DateValue),CONVERT(DATETIME2,TimeValue))
   FROM dbo.DateTimeTest; --Yup. The table has the same name as the database.
    SET STATISTICS TIME OFF;
GO 3
--=====================================================================================================================
--===== Clear proc and buffer cache only on the DateTimeTest database without affecting any others.
  PRINT REPLICATE('=',119);
    USE master;
  ALTER DATABASE DateTimeTest SET OFFLINE WITH ROLLBACK IMMEDIATE;
  ALTER DATABASE DateTimeTest SET ONLINE;
    USE DateTimeTest;
        CHECKPOINT;
GO
--===== Method 2 Performance Test =====================================================================================
        RAISERROR('********** Method 2 **********',0,0) WITH NOWAIT;
DECLARE @BitBucket DATETIME2; --Takes display time out of the picture.
    SET STATISTICS TIME ON;
 SELECT @BitBucket = CONVERT(DATETIME2,CONVERT(CHAR(9),DateValue,112)+CONVERT(CHAR(16),TimeValue))
   FROM dbo.DateTimeTest; --Yup. The table has the same name as the database.
    SET STATISTICS TIME OFF;
GO 3
--=====================================================================================================================
--===== Clear proc and buffer cache only on the DateTimeTest database without affecting any others.
  PRINT REPLICATE('=',119);
    USE master;
  ALTER DATABASE DateTimeTest SET OFFLINE WITH ROLLBACK IMMEDIATE;
  ALTER DATABASE DateTimeTest SET ONLINE;
    USE DateTimeTest;
        CHECKPOINT;
GO
--===== Method 3 Performance Test =====================================================================================
        RAISERROR('********** Method 3 **********',0,0) WITH NOWAIT;
DECLARE @BitBucket DATETIME2; --Takes display time out of the picture.
    SET STATISTICS TIME ON;
 SELECT @BitBucket = CONVERT(DATETIME2,CONCAT(DateValue,' ',TimeValue))
   FROM dbo.DateTimeTest; --Yup. The table has the same name as the database.
    SET STATISTICS TIME OFF;
GO 3
--=====================================================================================================================
--===== Clear proc and buffer cache only on the DateTimeTest database without affecting any others.
  PRINT REPLICATE('=',119);
    USE master;
  ALTER DATABASE DateTimeTest SET OFFLINE WITH ROLLBACK IMMEDIATE;
  ALTER DATABASE DateTimeTest SET ONLINE;
    USE DateTimeTest;
        CHECKPOINT;
GO
--===== Method 4 Performance Test =====================================================================================
        RAISERROR('********** Method 4 **********',0,0) WITH NOWAIT;
DECLARE @BitBucket DATETIME2; --Takes display time out of the picture.
    SET STATISTICS TIME ON;
 SELECT @BitBucket = CONVERT(DATETIME2,CONVERT(VARBINARY(6),TimeValue)+CONVERT(BINARY(3),DateValue))
   FROM dbo.DateTimeTest --Yup. The table has the same name as the database.
    SET STATISTICS TIME OFF;
GO 3
--===== Run Complete ==================================================================================================
  PRINT REPLICATE('=',119);
        RAISERROR('********** RUN COMPLETE **********',0,0) WITH NOWAIT;
    SET NOCOUNT OFF;
